<?php

declare(strict_types=1);

namespace Bongo\Estimate\Traits;

trait HasItemNumber
{
    public function initializeHasItemNumber(): void
    {
        $this->mergeFillable(['number']);
    }

    public static function bootHasItemNumber(): void
    {
        static::creating(function ($model) {
            $model->number = $model->estimate->number.'-'.$model->estimate->items()->count() + 1;
        });
    }
}
