<?php

declare(strict_types=1);

namespace Bongo\Estimate\Traits;

use Bongo\Estimate\Actions\GenerateNumber;

trait HasNumber
{
    public function initializeHasNumber(): void
    {
        $this->mergeFillable(['number']);
    }

    public static function bootHasNumber(): void
    {
        static::creating(function ($model) {
            $model->number = GenerateNumber::forEstimate();
        });
    }
}
