<?php

declare(strict_types=1);

namespace Bongo\Estimate\Traits;

use Bongo\Estimate\Interfaces\PriceTypeInterface;

trait HasPriceType
{
    public function initializeHasPriceType(): void
    {
        $this->mergeFillable(['price_type']);
    }

    public function scopePerTreatmentAndPerMonth($query)
    {
        return $query->where('price_type', PriceTypeInterface::PER_TREATMENT_MONTH);
    }

    public function isPerTreatmentAndPerMonth(): bool
    {
        return $this->price_type === PriceTypeInterface::PER_TREATMENT_MONTH;
    }

    public function scopePerTreatment($query)
    {
        return $query->where('price_type', PriceTypeInterface::PER_TREATMENT);
    }

    public function isPerTreatment(): bool
    {
        return $this->price_type === PriceTypeInterface::PER_TREATMENT;
    }

    public function scopePerMonth($query)
    {
        return $query->where('price_type', PriceTypeInterface::PER_MONTH);
    }

    public function isPerMonth(): bool
    {
        return $this->price_type === PriceTypeInterface::PER_MONTH;
    }

    public function getPriceTypeLabelAttribute(): string
    {
        $options = $this->getPriceTypeOptions();

        return $options[$this->price_type] ?? 'Unknown';
    }

    public function getPriceTypeOptions(): array
    {
        return [
            PriceTypeInterface::PER_TREATMENT_MONTH => 'Per Treatment & Per Month',
            PriceTypeInterface::PER_TREATMENT => 'Per Treatment',
            PriceTypeInterface::PER_MONTH => 'Per Month',
        ];
    }
}
