<?php

declare(strict_types=1);

namespace Bongo\Estimate\Traits;

use Bongo\Estimate\Calculators\EstimateItemPriceCalculator;
use Bongo\Framework\Casts\Pence;
use Illuminate\Contracts\Container\BindingResolutionException;

trait HasTotals
{
    public function initializeHasTotals(): void
    {
        $this->mergeFillable([
            'cost_per_m2',
            'subtotal',
            'tax_rate',
            'tax',
            'total',
            'price_per_month',
        ]);

        $this->mergeCasts([
            'cost_per_m2' => Pence::class,
            'subtotal' => Pence::class,
            'tax_rate' => 'float',
            'tax' => Pence::class,
            'total' => Pence::class,
            'price_per_month' => Pence::class,
        ]);
    }

    /** @throws BindingResolutionException */
    public function updateTotals(): void
    {
        $this->load(['item', 'plan', 'planItem']);

        if (! $this->hasItem() || ! $this->hasPlan() || ! $this->hasPlanItem()) {
            return;
        }

        (new EstimateItemPriceCalculator())
            ->setEstimateItemPrice($this)
            ->calculate()
            ->save();
    }
}
