@extends('framework::backend.layouts.app')

@section('content')
    @component('blade::content_header')
        {{ trans('estimate::backend.index') }}
        @slot('actions')
            @if(config('estimate.export_enabled'))
                @linkButton([
                    'name' => 'Export',
                    'url' => route('backend.estimate.export')
                ])
            @endif
            @linkButton([
                'name' => 'Locations',
                'url' => route('backend.estimate_location.index')
            ])
            @linkButton([
                'name' => 'Plans',
                'url' => route('backend.estimate_plan.index')
            ])
            @linkButton([
                'name' => 'Services',
                'url' => route('backend.estimate_service.index')
            ])
            @backButton([
                'name' => trans('dashboard::backend.index')
            ])
        @endslot
    @endcomponent

    @component('blade::content_body')
        <data-table
            search-url="{{ route('backend.estimate.datatable') }}"
            resource-url="{{ route('backend.estimate.index') }}"
            order-by="number"
            order-direction="desc"
            v-cloak
        >
            <template slot="custom-filters" slot-scope="{updateFilters, getFilterValue}">
                <data-table-filter :first-child="true">
                    <select
                        class="form-input w-full block rounded-sm pr-10 sm:text-sm sm:leading-5"
                        :value="getFilterValue('status')"
                        @change="event => updateFilters(event, 'status')"
                    >
                        <option value="">All Statuses</option>
                        <option value="draft">Draft</option>
                        <option value="pending">Pending</option>
                        <option value="accepted">Accepted</option>
                        <option value="rejected">Rejected</option>
                    </select>
                    <div class="pointer-events-none absolute inset-y-0 right-0 flex items-center px-2 text-gray-500">
                        <svg class="fill-current h-4 w-6" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20">
                            <path d="M9.293 12.95l.707.707L15.657 8l-1.414-1.414L10 10.828 5.757 6.586 4.343 8z"/>
                        </svg>
                    </div>
                </data-table-filter>
            </template>

            <template slot="default" slot-scope="{items, itemIndex, isSelected, setAsSelectedItem, viewUrl}">
                <div class="grid md:grid-cols-2 gap-3">
                    <v-card
                        v-for="(item, index) in items"
                        :key="item.id"
                        :id="itemIndex(item, index)"
                        :class="['col-span-1', { selected : isSelected(item, index) }]"
                        @click="setAsSelectedItem(item, index)"
                    >
                        <div class="grid grid-cols-1 lg:grid-cols-2 gap-2 items-center">
                            <div class="col-span-1">
                                <a :href="viewUrl(item)" title="View"
                                   class="block font-semibold hover:text-primary-500 focus:text-primary-600"
                                >
                                    <span v-if="item.first_name || item.last_name">
                                        @{{ item.first_name }} @{{ item.last_name }}
                                    </span>
                                    <span v-else>
                                        -- --
                                    </span>
                                </a>
                                <div class="text-sm">
                                    <span>
                                        Ref: @{{ item.number }}
                                    </span>
                                    &nbsp;|&nbsp;
                                    <span :class="['font-bold', item.status === 'accepted' ? 'text-green-400' : 'text-red-500']">
                                        @{{ item.status | ucwords }}
                                    </span>
                                </div>
                                <div class="text-sm">
                                    <span class="text-gray-500">
                                        @{{ item.city }}
                                    </span>
                                    <span v-if="item.city">
                                        &nbsp;|&nbsp;
                                    </span>
                                    <span class="text-gray-500">
                                        @{{ item.county }}
                                    </span>
                                </div>
                            </div>

                            <div class="col-span-1 text-left lg:text-right">
                                <div class="inline-flex flex-wrap items-center text-center px-3 py-2 rounded leading-5 bg-gray-100">
                                    <span class="w-full font-bold text-gray-600">
                                        @{{ item.items_count }}
                                    </span>
                                    <span class="w-full text-xs text-gray-500">
                                        Items
                                    </span>
                                </div>
                            </div>
                        </div>
                        <template slot="footer">
                            <div class="grid grid-cols-2 gap-2 items-center">
                                <div class="col-span-1">
                                    <span class="inline-flex items-center px-2 py-0.5 rounded text-xs font-medium leading-4 bg-gray-200 text-gray-500">
                                        @{{ item.created_at }}
                                    </span>
                                </div>
                                <div class="col-span-1 text-right">
                                    <v-button :link="viewUrl(item)">View</v-button>
                                </div>
                            </div>
                        </template>
                    </v-card>
                </div>
            </template>
        </data-table>
    @endcomponent
@stop
