<section class="md:grid md:grid-cols-2 md:gap-6">
    <div class="md:col-span-1">
        @component('blade::card', ['cardClass' => 'mb-4 md:mb-0'])
            <div class="grid grid-cols-1 col-gap-4 row-gap-4 sm:grid-cols-2">
                <div class="sm:col-span-1">
                    @input([
                        'name' => 'name',
                        'value' => $estimatePlan->name,
                        'placeholder' => 'Basic',
                        'required' => 'true'
                    ])
                </div>
                <div class="sm:col-span-1">
                    @select([
                        'name' => 'status',
                        'value' => $estimatePlan->status,
                        'options' => get_enum_values('estimate_plans', 'status'),
                        'required' => 'true'
                    ])
                </div>
                <div class="sm:col-span-1">
                    <x-estimate-service-dropdown
                        :estimate-plan="$estimatePlan"
                    />
                </div>
                <div class="sm:col-span-1">
                    @select([
                        'name' => 'price_type',
                        'value' => $estimatePlan->price_type,
                        'options' => $estimatePlan->getPriceTypeOptions(),
                        'required' => 'true'
                    ])
                </div>
                <div class="sm:col-span-1">
                    @select([
                        'name' => 'calculation_type',
                        'value' => $estimatePlan->calculation_type,
                        'options' => $estimatePlan->getCalculationTypeOptions(),
                        'required' => 'true'
                    ])
                </div>
                <div class="sm:col-span-1">
                    @select([
                        'name' => 'default',
                        'value' => $estimatePlan->default,
                        'options' => [
                            '0' => 'No',
                            '1' => 'Yes'
                        ]
                    ])
                </div>
            </div>
        @endcomponent
    </div>
    <div class="md:col-span-1">
        @component('blade::card', ['cardClass' => 'mb-4 md:mb-0'])
            <div class="grid grid-cols-1 col-gap-4 row-gap-4 sm:grid-cols-2">
                <div class="sm:col-span-1">
                    @input([
                        'name' => 'treatments',
                        'value' => $estimatePlan->treatments,
                        'placeholder' => '14',
                        'required' => 'true',
                    ])
                </div>
                <div class="sm:col-span-1">
                    @input([
                        'name' => 'chargeable_treatments',
                        'value' => $estimatePlan->chargeable_treatments,
                        'placeholder' => '7',
                        'required' => 'true',
                    ])
                </div>
                <div class="sm:col-span-1">
                    @input([
                        'name' => 'min_price',
                        'value' => $estimatePlan->min_price,
                        'placeholder' => '28',
                        'required' => 'true',
                    ])
                </div>
                <div class="sm:col-span-1">
                    @input([
                        'name' => 'visits',
                        'value' => $estimatePlan->visits,
                        'placeholder' => '5',
                        'required' => 'true',
                    ])
                </div>
            </div>
        @endcomponent
    </div>
</section>

<section class="mt-4">
    <estimate-plan-builder
        :estimate-plan="{{ json_encode($estimatePlan) }}"
    ></estimate-plan-builder>
</section>
