@extends('framework::backend.layouts.app')

@section('content')

    @component('blade::content_header')
        {{ $estimatePlan->name }}
        @slot('actions')
            @linkButton([
                'name' => trans('estimate::backend.duplicate'),
                'url' => route('backend.estimate_plan.duplicate', $estimatePlan->id)
            ])
            @deleteButton([
                'class' => 'btn-danger mr-2',
                'name' => trans('estimate::backend.plan_delete'),
                'url' => route('backend.estimate_plan.destroy', $estimatePlan->id)
            ])
            @backButton([
                'name' => trans('estimate::backend.plan_index'),
                'url' => route('backend.estimate_plan.index')
            ])
            @editButton([
                'name' => trans('estimate::backend.plan_edit'),
                'url' => route('backend.estimate_plan.edit', $estimatePlan->id)
            ])
        @endslot
    @endcomponent

    @component('blade::content_body')
        <section class="md:grid md:grid-cols-2 md:gap-6">
            <div class="md:col-span-1">
                @component('blade::card', ['cardClass' => 'mb-4 md:mb-0'])
                    <div class="grid grid-cols-1 col-gap-4 row-gap-4 sm:grid-cols-2">
                        <div class="sm:col-span-1">
                            @static([
                                'name' => 'Name',
                                'value' => $estimatePlan->name
                            ])
                        </div>
                        <div class="sm:col-span-1">
                            @static([
                                'name' => 'Status',
                                'value' => ! empty($estimatePlan->status) ? ucwords($estimatePlan->status) : null
                            ])
                        </div>
                        <div class="sm:col-span-1">
                            @static([
                                'name' => 'Service',
                                'value' => $estimatePlan->service->name
                            ])
                        </div>
                        <div class="sm:col-span-1">
                            @static([
                                'name' => 'Price Type',
                                'value' => ! empty($estimatePlan->price_type)
                                    ? $estimatePlan->price_type_label
                                    : null
                            ])
                        </div>
                        <div class="sm:col-span-1">
                            @static([
                                'name' => 'Calculation Type',
                                'value' => ! empty($estimatePlan->calculation_type)
                                    ? $estimatePlan->calculation_type_label
                                    : null
                            ])
                        </div>
                        <div class="sm:col-span-1">
                            @static([
                                'name' => 'Default',
                                'value' => $estimatePlan->default ? 'Yes' : 'No'
                            ])
                        </div>
                    </div>
                @endcomponent
            </div>

            <div class="md:col-span-1">
                @component('blade::card', ['cardClass' => 'mb-4 md:mb-0'])
                    <div class="grid grid-cols-1 col-gap-4 row-gap-4 sm:grid-cols-2">
                        <div class="sm:col-span-1">
                            @static([
                                'name' => 'Treatments',
                                'value' => $estimatePlan->treatments
                            ])
                        </div>
                        <div class="sm:col-span-1">
                            @static([
                                'name' => 'Chargeable Treatments',
                                'value' => $estimatePlan->chargeable_treatments
                            ])
                        </div>
                        <div class="sm:col-span-1">
                            @static([
                                'name' => 'Minimum Price',
                                'value' => $estimatePlan->min_price
                            ])
                        </div>
                        <div class="sm:col-span-1">
                            @static([
                                'name' => 'Visits',
                                'value' => $estimatePlan->visits
                            ])
                        </div>
                    </div>
                @endcomponent
            </div>
        </section>

        <section class="mt-4">
            @if ($estimatePlan->hasItems())
                @foreach($estimatePlan->items as $estimatePlanItem)
                    @include('estimate::backend.plan.partials.item')
                @endforeach
            @else
                @component('blade::card')
                    <div class="message text-center">
                        <div class="message-text font-semibold">
                            No Plan Items Found
                        </div>
                    </div>
                @endcomponent
            @endif
        </section>
    @endcomponent

@stop
