@extends('framework::backend.layouts.app')

@section('content')

    @component('blade::content_header')
        {{ $estimateService->name }}
        @slot('actions')
            @deleteButton([
                'class' => 'btn-danger mr-2',
                'permission' => 'estimate_service.delete',
                'name' => trans('estimate::backend.service_delete'),
                'url' => route('backend.estimate_service.destroy', $estimateService->id)
            ])
            @backButton([
                'name' => trans('estimate::backend.service_index'),
                'url' => route('backend.estimate_service.index')
            ])
            @editButton([
                'permission' => 'estimate_service.update',
                'name' => trans('estimate::backend.service_edit'),
                'url' => route('backend.estimate_service.edit', $estimateService->id)
            ])
        @endslot
    @endcomponent

    @component('blade::content_body')
        <section class="md:grid md:grid-cols-2 md:gap-6">

            <div class="md:col-span-1">
                @component('blade::card', ['cardClass' => 'mb-4 md:mb-0'])
                    <div class="grid grid-cols-1 col-gap-4 row-gap-4 sm:grid-cols-2">
                        <div class="sm:col-span-1">
                            @static([
                                'name' => 'Name',
                                'value' => $estimateService->name
                            ])
                        </div>
                        <div class="sm:col-span-1">
                            @static([
                                'name' => 'Status',
                                'value' => ! empty($estimateService->status) ? ucwords($estimateService->status) : null
                            ])
                        </div>
                    </div>
                @endcomponent
            </div>

            <div class="md:col-span-1">
                @component('blade::card', ['cardClass' => 'mb-4 md:mb-0'])
                    <div class="grid grid-cols-1 col-gap-4 row-gap-4 sm:grid-cols-2">
                        <div class="sm:col-span-1">
                            @static([
                                'name' => 'Default',
                                'value' => $estimateService->default ? 'Yes' : 'No'
                            ])
                        </div>
                    </div>
                @endcomponent
            </div>

        </section>
    @endcomponent

@stop
