@if(App::environment('local') || auth()->user()->isDeveloper())
    <div class="debug-block">
        <div class="debug-field">
            <span class="debug-key">Total Area:</span>
            <span class="debug-value">
                {{ ! empty($estimateItem->total_area_m2) ? number_format($estimateItem->total_area_m2, 2) : '--' }}m²
            </span>
        </div>
        <div class="debug-field">
            <span class="debug-key">Plan Area:</span>
            <span class="debug-value">
                {{ ! empty($price->planItem->area_m2) ? number_format($price->planItem->area_m2, 2) : '--' }}m²
            </span>
        </div>
        <div class="debug-field">
            <span class="debug-key">Plan Price:</span>
            <span class="debug-value">
                £{{ ! empty($price->planItem->cost_per_m2) ? number_format($price->planItem->cost_per_m2, 2) : '--' }}
            </span>
        </div>
        <div class="debug-field">
            <span class="debug-key">Plan Type:</span>
            <span class="debug-value">
                {{ $price->plan->calculation_type ?? '--' }}
            </span>
        </div>
    </div>
    <div class="debug-block">
        <div class="debug-field">
            <span class="debug-key">Subtotal:</span>
            <span class="debug-value">
                £{{ ! empty($price->subtotal) ? number_format($price->subtotal, 2) : '--' }}
            </span>
        </div>
        <div class="debug-field">
            <span class="debug-key">Min Price:</span>
            <span class="debug-value">
                £{{ ! empty($price->plan->min_price) ? number_format($price->plan->min_price, 2) : '--' }}
            </span>
        </div>
        <div class="debug-field">
            <span class="debug-key">Tax:</span>
            <span class="debug-value">
                £{{ ! empty($price->tax) ? number_format($price->tax, 2) : '--' }}
            </span>
        </div>
        <div class="debug-field">
            <span class="debug-key">Total:</span>
            <span class="debug-value">
                £{{ ! empty($price->total) ? number_format($price->total, 2) : '--' }}
            </span>
        </div>
    </div>
@endif
