@extends('framework::mail.layouts.app')

@php
    $cellStyle = 'padding-top: 5px; padding-right: 0; padding-bottom: 5px; padding-left: 0; border:0; vertical-align:top;';
    $labelWidth = '30%';
    $valueWidth = '75%';
@endphp

@section('content')
    @component('framework::mail.layouts.partials.section', ['hasBorder' => true])
        @include($htmlViewPartials['thank_you_text'])
    @endcomponent

    @component('framework::mail.layouts.partials.section', ['hasBorder' => true])
        @include($htmlViewPartials['contact_details'])
    @endcomponent

    @component('framework::mail.layouts.partials.section', ['hasBorder' => true])
        @include($htmlViewPartials['call_to_action'])
    @endcomponent

    @if(count($estimateItem->getAreas()) > 0)
        @component('framework::mail.layouts.partials.section', ['hasBorder' => true])
            <img data-time="{{ now()->timestamp }}"
                 style="width: 100%;"
                 src="{{ $estimateItem->getStaticMap() }}"
                 alt=""
            >
        @endcomponent
    @endif

    @component('framework::mail.layouts.partials.section', ['hasBorder' => true])
        @include($htmlViewPartials['measurement_summary'])
    @endcomponent

    @if($estimateItem->hasSinglePrice() && $singlePrice = $estimateItem->getSinglePrice())
        @component('framework::mail.layouts.partials.section', ['hasBorder' => true])
            @include($htmlViewPartials['single_price'], ['singlePrice' => $singlePrice])
        @endcomponent
    @endif

    @if($estimateItem->hasMultiplePrices())
        @component('framework::mail.layouts.partials.section', ['hasBorder' => true])
            @includeIf($htmlViewPartials['pricing_table'])
        @endcomponent
    @endif

    @component('framework::mail.layouts.partials.section', ['hasBorder' => true])
        @include($htmlViewPartials['footer_text'])
    @endcomponent
@stop
