@php
    $sharedStyle = 'padding-top: 5px; padding-right: 5px; padding-bottom: 5px; padding-left: 5px; border:0; vertical-align:middle;';
    $thStyle = 'background: #222222; color: #ffffff; border: 1px solid #333333;';
    $tdStyle = 'color: #222222; border: 1px solid #dddddd; border-top: 0;';
    $tdEvenStyle = 'background: #ffffff;';
    $tdOddStyle = 'background: #eeeeee;';
@endphp

<table class="pricing-table with-vat" width="100%" cellpadding="0" border="0" cellspacing="0">
    <thead>
        <tr>
            <th style="{{ $sharedStyle }} {{ $thStyle }}">
                Plan
            </th>
            <th style="{{ $sharedStyle }} {{ $thStyle }}">
                Subtotal
            </th>
            <th style="{{ $sharedStyle }} {{ $thStyle }}">
                VAT
            </th>
            <th style="{{ $sharedStyle }} {{ $thStyle }}">
                Total
            </th>
        </tr>
    </thead>
    <tbody>
        @foreach($estimateItem->prices as $price)
            <tr class="{{ $price->plan->key ?? '' }}">
                <td style="{{ $sharedStyle }} {{ $tdStyle }} {{ $loop->even ? $tdEvenStyle : $tdOddStyle }}">
                    <div>{{ $price->plan->name ?? '-- --' }}</div>

                    @if($price->plan->isPerTreatmentAndPerMonth())
                        <div style="font-size: 10px;">
                            {{ $price->plan?->treatments ?? '-- --' }} Treatments
                            Across {{ $price->plan?->visits ?? '-- --' }} Visits
                        </div>
                    @elseif($price->plan->isPerTreatment())
                        <div style="font-size: 10px;">
                            Per Treatment
                        </div>
                    @elseif($price->plan->isPerMonth())
                        <div style="font-size: 10px;">
                            Per Month
                        </div>
                    @endif
                </td>
                <td style="{{ $sharedStyle }} {{ $tdStyle }} {{ $loop->even ? $tdEvenStyle : $tdOddStyle }}">
                    £{{ ! empty($price->subtotal) ? number_format($price->subtotal, 2) : '0.00' }}
                </td>
                <td style="{{ $sharedStyle }} {{ $tdStyle }} {{ $loop->even ? $tdEvenStyle : $tdOddStyle }}">
                    £{{ ! empty($price->tax) ? number_format($price->tax, 2) : '0.00' }}
                </td>
                <td style="{{ $sharedStyle }} {{ $tdStyle }} {{ $loop->even ? $tdEvenStyle : $tdOddStyle }}">
                    £{{ ! empty($price->total) ? number_format($price->total, 2) : '0.00' }}

                    @if($price->plan->isPerTreatmentAndPerMonth())
                        <div style="font-size: 10px;">
                            or £{{ ! empty($price->price_per_month) ? number_format($price->price_per_month, 2) : '0.00' }} per month
                        </div>
                    @endif
                </td>
            </tr>
        @endforeach
    </tbody>
</table>
