# Changelog

All notable changes to `bongo/estimate` will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/).

## [Unreleased]

## [4.0.13] - 2026-01-19

### Added
- **AI Context Documentation**: Comprehensive documentation for AI-assisted development
  - `.cursorrules` - Cursor IDE guidance with project structure, multi-step workflow, calculator patterns, and coding conventions
  - `CLAUDE.md` - Claude Code quick reference with commands, architecture summary, key files, and configuration details
  - `ARCHITECTURE.md` - Detailed architecture with directory structure, class diagrams, data flows, and extension points
  - `.github/copilot-instructions.md` - GitHub Copilot code templates and common patterns
  - Enhanced `README.md` with installation, configuration, and usage examples

## [4.0.12] - 2026-01-12

### Added
- **Price Type Support**: Added flexible pricing display options for estimate plans
  - `PriceTypeInterface` with constants: `PER_TREATMENT` (default), `PER_MONTH`, `PER_YEAR`
  - Migration `2024_01_01_000012_add_price_type_column_to_estimate_plans_table.php` adds `price_type` column
  - `HasPriceType` trait for managing price type behavior
  - `EstimatePlan::getPriceType()` method with fallback to default
  - `EstimateItem::getPriceType()` method delegating to plan
  - Updated all pricing display templates to respect price type setting
  - Changes affect: step 3 views (single price, default, with_vat, with_features) and email templates

### Changed
- **Pricing Display**: Footer text and pricing tables now dynamically adjust based on price type
  - "per treatment" vs "per month" vs "per year" labels
  - Treatment count display shown only for PER_TREATMENT type
  - Consistent labeling across frontend and email views

## [4.0.11] - 2026-01-12

### Fixed
- **Typo**: Corrected "bellow" to "below" in frontend views
- **Console Helper**: Fixed "console function not found" error by adding proper function check

### Added
- **Unit Tests**: Added basic unit tests for core models and functionality
  - Test coverage for models, traits, calculators
  - Factory support for testing

### Improved
- **Testing Infrastructure**: Enhanced testing capabilities
  - Added definitions to model factories for consistent test data
  - Added `plan` relationship to `EstimateItem` factory
  - Fixed factory relationships for proper test data generation
  - Resolved lazy loading errors in tests

### Changed
- **Documentation**: Updated README.md with current package information
- **Code Quality**: Fixed PHPStan level 1 errors for static analysis compliance
- **Code Style**: Ran code cleanup to ensure consistent formatting
- **Development Files**: Added missing package configuration files
- **Factories**: Added default factories for all models
- **Standards**: Updated root configuration files to match current Bongo standards

## [4.0.10] - 2025-11-20

### Changed
- **Form Submit**: Temporarily disabled "please wait" effect on form button
  - Effect clashed with captcha submit function
  - Prevents double-submit while maintaining captcha validation

## [4.0.9] - 2025-11-18

### Changed
- **Captcha Integration**: Updated estimate builder to use new custom captcha package
  - Migrated from generic ReCAPTCHA to custom Bongo captcha solution
  - Improved spam protection with package-specific implementation

## [4.0.8] - 2025-10-20

### Changed
- **ReCAPTCHA Dependency**: Moved honeypot and ReCAPTCHA dependency to framework level
  - Centralized spam protection across all packages
  - Simplified package dependencies
  - Updated review form to use new framework ReCAPTCHA functionality

## [4.0.7] - 2025-07-07

### Added
- **Duplicate Plan Functionality**: Added ability to duplicate estimate plans
  - New duplicate button on plan show screen
  - `EstimatePlan::duplicate()` method creates copy with randomized name
  - Automatically duplicates all associated `EstimatePlanItem` records
  - Route: `backend.estimate.plan.duplicate` (POST)
  - Useful for creating similar pricing tiers quickly

## [4.0.6] - 2025-06-23

### Added
- **Plan Items Form**: Enhanced UI for managing plan items
  - Improved interface for creating/editing area-based pricing breakpoints
  - Better UX for configuring tiered pricing

## [4.0.5] - 2025-06-09

### Added
- **Export Tracking**: Added `exported_at` and `export_error` fields to `EstimateItem` model
  - Tracks when individual items are exported to external systems (e.g., RealGreen)
  - Fields added to `$fillable` array for mass assignment
  - Enables per-item export status monitoring

### Fixed
- **Price Calculation**: Fixed issues with missing estimate item prices
  - Added debugging logs for troubleshooting price generation
  - Resolved edge cases in price calculator

## [4.0.4] - 2025-06-02

### Added
- **Service Parameter**: Added ability to pass service as URL parameter to estimator
  - Pre-selects service when accessing estimate form
  - Streamlines user experience for single-service flows
  - URL format: `/estimate?service={service_id}`

### Changed
- **View Structure**: Completed conversion to new service and plans format
  - All views updated to use database-driven services instead of config
  - Added ability to override each individual view partial
  - Improved template organization for easier customization

## [4.0.3] - 2025-05-19

### Added
- **Multiple Services Support**: Major architectural change to support multiple estimate services
  - Step 1: Shows available services, auto-selects if only one exists
  - Steps 1, 2, 3: Updated to handle multiple estimate items per estimate
  - Validation at each stage for estimate, item, service, and prices
  - `GetDefaultService` action for auto-selection logic
  - `FindEstimateItem` action for retrieving items by service
  - `EstimateItemNotFoundException` for better error handling
  - Enhanced view partials for multi-service display

### Added
- **ReCAPTCHA Protection**: Added Google ReCAPTCHA to estimate submission forms
  - Spam protection for public estimate requests
  - Configurable via system settings
  - Works with framework's ReCAPTCHA integration

### Changed
- **View Organization**: Moved more view files into partials for easier override
  - Frontend pricing tables modularized
  - Email templates modularized
  - Improves theme customization capabilities

## [4.0.2] - 2025-05-12

### Added
- **EstimateItemPriceCalculator**: Created dedicated calculator class for pricing logic
  - Fluent builder pattern for complex calculations
  - Easier to debug and maintain than inline calculations
  - Handles: area-based pricing, tax calculations, treatment schedules, voucher discounts
  - Methods: `setEstimateItem()`, `setPlan()`, `setArea()`, `calculate()`

### Added
- **Estimate Items Admin Tab**: New admin interface for managing estimate items
  - View all items associated with an estimate
  - Edit item details (service, plan, areas)
  - Recalculate pricing on-demand
  - Better visibility into estimate composition

### Fixed
- **Decimal Precision**: Fixed issue with estimates having large `total_area` decimal values
  - Updated database column precision
  - Prevents truncation of area measurements

### Changed
- **Plan Migration**: Updated `estimate:migrate-plans` command to include treatments and visits
  - Automatically populates `treatments_per_year` and `chargeable_treatments_per_year`
  - Migrates complete pricing structure from v3 configs

## [4.0.1] - 2025-04-28

### Added
- **Database-Driven Architecture**: Migrated from config-based to database-driven pricing
  - New models: `EstimateItem`, `EstimateItemPrice`
  - New tables: `estimate_items`, `estimate_item_prices`
  - `Estimate` now has many `EstimateItem` records
  - Each `EstimateItem` has many `EstimateItemPrice` records (one per plan)
  - Command: `estimate:upgrade-to-v4` migrates v3 data to v4 structure
  - Command: `estimate:migrate-plan-items` imports plan items from config to database

### Added
- **Status Interface**: Shared status constants across all models
  - `StatusInterface` with `PENDING`, `ACTIVE`, `INACTIVE` constants
  - Used by: `Estimate`, `EstimateService`, `EstimatePlan`, `EstimateLocation`
  - Ensures consistency across package

### Breaking Changes
- **Architecture Change**: v4.0 is a major rewrite of the estimate system
  - Config-based pricing replaced with database tables
  - Requires migration command to upgrade from v3.x
  - Old estimate data structure incompatible without migration

## [4.0.0] - 2025-04-14

### Added
- **Estimate Plans**: Complete CRUD for estimate plans (pricing tiers)
  - Model: `EstimatePlan` with relationship to `EstimateService`
  - Controller: `PlanController` for backend management
  - Views: create, edit, show, index for plans
  - Migration: Creates `estimate_plans` table
  - Fields: name, slug, status, treatments_per_year, chargeable_treatments_per_year, is_featured
  - Relationship: `EstimateService` hasMany `EstimatePlan`

### Added
- **Estimate Plan Items**: Area-based pricing breakpoints
  - Model: `EstimatePlanItem` for pricing rules (e.g., "50m² = £28")
  - Migration: Creates `estimate_plan_items` table
  - Relationship: `EstimatePlan` hasMany `EstimatePlanItem`
  - Supports tiered pricing based on measured area

### Added
- **Estimate Services**: Service categories for different estimate types
  - Model: `EstimateService` for organizing estimate types
  - Controller: `ServiceController` for backend management
  - Migration: Creates `estimate_services` table
  - Command: `estimate:migrate-areas` imports existing areas from system settings
  - Allows multiple service types (e.g., "Lawn Care", "Pest Control")

### Added
- **Estimate Locations**: Service coverage areas with radius mapping
  - Model: `EstimateLocation` for geographic service areas
  - Controller: `LocationController` for backend CRUD
  - Views: index, create, edit, show with integrated radius map
  - Component: `<x-radius-map />` Blade component for coverage visualization
  - Migration: Creates `estimate_locations` table
  - Fields: name, line_1, line_2, city, county, postcode, latitude, longitude, radius
  - Validation: Checks if customer address falls within service radius

## [3.1.26] - 2025-03-10

### Added
- **RealGreen Integration**: Added fields for tracking exports to RealGreen CRM
  - Migration `2025_03_10_000001_add_real_green_fields_to_estimates_table.php`
  - New fields: `exported_at` (timestamp), `export_error` (text)
  - Enables integration with `bongo/realgreen` package
  - Tracks successful exports and captures error messages

## [3.1.25] - 2025-03-04

### Fixed
- **Date Cast**: Fixed compatibility with new framework Date cast
  - Updated `Estimate` model to use framework's Date cast class
  - Ensures proper date serialization and formatting

## [3.1.24] - 2025-02-24

### Changed
- **Trait Refactoring**: Tidied up estimate module with trait-based architecture
  - Moved functionality into individual reusable traits
  - Traits: `HasAddress`, `HasContact`, `HasStatus`, `HasUUID`
  - Improves code organization and reusability

### Changed
- **Dependencies**: Updated dev dependencies for testing infrastructure
  - Prepared for PHPUnit 10 support
  - Updated testing tools and frameworks

### Changed
- **Code Quality**: Ran comprehensive code cleanup
  - Laravel Pint formatting applied
  - Consistent code style across package

### Changed
- **Migrations**: Updated migrations to use new Laravel format
  - Modern migration syntax
  - Better compatibility with Laravel 10+

## [3.1.23] - 2025-02-18

### Changed
- **Code Organization**: Tidied up code to prepare for v4.0 refactor
  - Improved structure for upcoming database-driven architecture
  - Better separation of concerns

## [3.0.18] - 2024-12-19

### Fixed
- **Static Map**: Removed URL encoding from static map generation
  - Fixed map rendering issues
  - Google Static Maps API compatibility

## [3.0.17] - 2024-12-10

### Added
- **Google Static Map**: Enhanced static map functionality
  - Improved map image generation for estimate locations
  - Better marker placement and styling
  - Polyline encoding for accurate coverage area visualization

## [3.0.16] - 2024-10-07

### Changed
- **Authentication**: Updated `auth.json` to use new repository credentials

## [3.0.15] - 2024-09-17

### Changed
- **ReCAPTCHA Toggle**: Views now check if ReCAPTCHA is enabled before rendering
  - Allows disabling ReCAPTCHA without code changes
  - Controlled via system settings

## [3.0.14] - 2024-08-05

### Added
- **Google ReCAPTCHA**: Spam protection for estimate submission forms
  - Integration with Google ReCAPTCHA v2
  - Configurable site key and secret key
  - Validates captcha on form submission

## [3.0.13] - 2024-07-01

### Added
- **Marketing Consent**: Added marketing consent checkbox to estimate forms
  - GDPR-compliant consent tracking
  - Stored with estimate record
  - Required for email marketing compliance

## [3.0.12] - 2024-05-13

### Changed
- **Pricing Update**: Updated estimate pricing calculation logic
  - Improved accuracy for complex scenarios
  - Better handling of edge cases

## [3.0.11] - 2024-05-13

### Added
- **Static Map Zoom Control**: Added configurable zoom level for static maps
  - Config key: `estimate.map_zoom_level`
  - Allows customization of map detail level
  - Better control over coverage area visualization

## [3.0.10] - 2024-05-13

### Added
- **House Name Support**: Added support for house names in address fields
  - `line_1` can now contain house name instead of just number
  - Improves address flexibility for UK properties
  - Better geocoding for named properties

## [3.0.9] - 2024-05-13

### Added
- **Session Debugging**: Added session data to estimate views for debugging
  - Helps troubleshoot multi-step form issues
  - Available in development mode only

## [3.0.8] - 2024-05-13

### Added
- **Estimate Number Prefix**: Configurable prefix for estimate reference numbers
  - Config key: `estimate.number_prefix` (default: "KLC-")
  - Generates unique references like "KLC-8137"
  - `GenerateNumber` action handles generation logic

## [3.0.7] - 2024-05-13

### Added
- **Map Image Caching**: Implemented caching for static map images
  - Reduces Google Maps API calls
  - Improves page load performance
  - Cache invalidation on address/area changes

## [3.0.6] - 2024-05-13

### Fixed
- **Division by Zero**: Fixed error in pricing calculations
  - Proper handling when area is zero
  - Graceful degradation for edge cases

## [3.0.5] - 2024-05-13

### Added
- **Voucher Code System**: Added promotional voucher code support
  - Field: `voucher_code` on estimate form
  - Discount calculations integrated into pricing
  - Tracks voucher usage
  - Admin interface for managing voucher codes

## [3.0.4] - 2024-05-13

### Enhanced
- **Admin Details**: Improved estimate details view in admin
  - Better layout of estimate information
  - Easier to review customer details
  - Enhanced pricing breakdown display

## [3.0.3] - 2024-05-13

### Fixed
- **Large Areas**: Fixed handling of very large area sizes
  - Database column precision increased
  - Prevents overflow on large properties
  - Better decimal precision for calculations

## [3.0.2] - 2024-05-13

### Changed
- **Pricing Table Styling**: Updated frontend pricing table styles
  - Improved responsive design
  - Better mobile experience
  - Enhanced visual hierarchy

## [2.0.26] - 2023-12-01

### Changed
- **Framework Compatibility**: Updated for Bongo Framework 2.0 compatibility
  - Removed strict types for PHP 7.4 support
  - Adjusted service provider for older Laravel versions
  - Maintained feature parity with 3.x branch

---

**Package**: `bongo/estimate`
**Description**: Estimation/quoting system with geographic service areas, tiered pricing plans, and automated calculations for recurring service costs
**Repository**: Internal
**License**: Proprietary

## Upgrade Guides

### Upgrading to 4.0

Version 4.0 is a major rewrite moving from config-based to database-driven architecture:

1. **Backup your data**: Export all existing estimates before upgrading
2. **Run migrations**: `php artisan migrate`
3. **Migrate services**: `php artisan estimate:migrate-areas`
4. **Migrate plan items**: `php artisan estimate:migrate-plan-items`
5. **Upgrade estimates**: `php artisan estimate:upgrade-to-v4`
6. **Review configuration**: Check `config/estimate.php` for new options
7. **Test thoroughly**: Verify pricing calculations match previous version

### Breaking Changes in 4.0

- Config-based pricing removed (was in `config/estimate.php`)
- New database tables: `estimate_services`, `estimate_plans`, `estimate_plan_items`, `estimate_items`, `estimate_item_prices`, `estimate_locations`
- `Estimate` model now uses relationships instead of config lookups
- Pricing calculation moved to `EstimateItemPriceCalculator` class
- Multi-service support changes frontend workflow

### New Features in 4.0

- Multiple estimate services per installation
- Database-managed pricing tiers (plans)
- Area-based pricing breakpoints (plan items)
- Geographic service coverage areas with radius validation
- Per-item pricing for multi-service estimates
- Duplicate plan functionality
- Enhanced admin interface for all entities
