<?php

declare(strict_types=1);

namespace Bongo\Estimate\Database\Factories;

use Bongo\Estimate\Interfaces\StatusInterface;
use Bongo\Estimate\Models\Estimate;
use Illuminate\Database\Eloquent\Factories\Factory;

class EstimateFactory extends Factory
{
    protected $model = Estimate::class;

    protected static int $numberSequence = 1;

    public function definition(): array
    {
        return [
            'first_name' => $this->faker->firstName(),
            'last_name' => $this->faker->lastName(),
            'email' => $this->faker->unique()->safeEmail(),
            'phone' => $this->faker->phoneNumber(),
            'address_1' => $this->faker->streetAddress(),
            'city' => $this->faker->city(),
            'postcode' => $this->faker->postcode(),
            'status' => StatusInterface::PENDING,
            'number' => $this->faker->unique()->randomNumber(4), // Random number for tests
        ];
    }

    public function pending(): Factory
    {
        return $this->state(fn () => [
            'status' => StatusInterface::PENDING,
        ]);
    }

    public function accepted(): Factory
    {
        return $this->state(fn () => [
            'status' => StatusInterface::ACCEPTED,
        ]);
    }

    public function rejected(): Factory
    {
        return $this->state(fn () => [
            'status' => StatusInterface::REJECTED,
        ]);
    }
}
