<?php

declare(strict_types=1);

namespace Bongo\Estimate\Database\Factories;

use Bongo\Estimate\Models\Estimate;
use Bongo\Estimate\Models\EstimateItem;
use Bongo\Estimate\Models\EstimatePlan;
use Bongo\Estimate\Models\EstimateService;
use Illuminate\Database\Eloquent\Factories\Factory;

class EstimateItemFactory extends Factory
{
    protected $model = EstimateItem::class;

    public function definition(): array
    {
        return [
            'estimate_id' => Estimate::factory(),
            'estimate_service_id' => EstimateService::factory(),
            'estimate_plan_id' => EstimatePlan::factory(),
            'total_area_m2' => $this->faker->randomFloat(2, 10, 500),
        ];
    }
}
