<?php

declare(strict_types=1);

namespace Bongo\Estimate\Actions;

class CalculateDistance
{
    public static function inMiles(
        float $fromLatitude,
        float $fromLongitude,
        float $toLatitude,
        float $toLongitude
    ): float|int {
        $milesMultiplier = 3959;

        $distance = acos(
            sin(deg2rad($fromLatitude)) * sin(deg2rad($toLatitude)) + cos(deg2rad($fromLatitude))
            * cos(deg2rad($toLatitude)) * cos(deg2rad($fromLongitude) - deg2rad($toLongitude))
        );

        return $distance * $milesMultiplier;
    }

    public static function inKilometers(
        float $fromLatitude,
        float $fromLongitude,
        float $toLatitude,
        float $toLongitude
    ): float|int {
        $kilometersMultiplier = 6380;

        $distance = acos(
            sin(deg2rad($fromLatitude)) * sin(deg2rad($toLatitude)) + cos(deg2rad($fromLatitude))
            * cos(deg2rad($toLatitude)) * cos(deg2rad($fromLongitude) - deg2rad($toLongitude))
        );

        return $distance * $kilometersMultiplier;
    }
}
