<?php

declare(strict_types=1);

namespace Bongo\Estimate\Actions;

use Bongo\Estimate\Interfaces\StatusInterface;
use Bongo\Estimate\Models\Estimate;

class FindEstimate
{
    public static function byUuid(?string $uuid): ?Estimate
    {
        return Estimate::query()
            ->where('uuid', $uuid)
            ->whereIn('status', [
                StatusInterface::DRAFT,
                StatusInterface::PENDING,
            ])
            ->first();
    }
}
