<?php

declare(strict_types=1);

namespace Bongo\Estimate\Components\Backend;

use Bongo\Estimate\Models\EstimatePlan;
use Bongo\Estimate\Models\EstimateService;
use Exception;
use Illuminate\Contracts\Foundation\Application;
use Illuminate\Contracts\View\Factory;
use Illuminate\Contracts\View\View;
use Illuminate\View\Component;

class ServiceDropdown extends Component
{
    public ?array $estimateServices = null;

    /** @throws Exception */
    public function __construct(public EstimatePlan $estimatePlan)
    {
        $this->estimateServices = EstimateService::query()
            ->where('status', EstimateService::ACTIVE)
            ->orderBy('default', 'desc')
            ->orderBy('name')
            ->pluck('name', 'id')
            ->toArray();
    }

    public function render(): Application|Factory|View
    {
        return view('estimate::backend.components.service_dropdown');
    }
}
