<?php

declare(strict_types=1);

namespace Bongo\Estimate\Events;

use Bongo\Estimate\Models\EstimateLocation;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class LocationCreated
{
    use Dispatchable;
    use InteractsWithSockets;
    use SerializesModels;

    public EstimateLocation $estimateLocation;

    public function __construct(EstimateLocation $estimateLocation)
    {
        $this->estimateLocation = $estimateLocation;
    }
}
