<?php

declare(strict_types=1);

namespace Bongo\Estimate\Exceptions;

use Exception;
use Illuminate\Http\RedirectResponse;

class EstimateNotFoundException extends Exception
{
    public function render(): RedirectResponse
    {
        session()->forget('estimate_id');
        session()->forget('estimate_item_id');

        return redirect()
            ->route('frontend.estimate.step_1.show')
            ->with([
                'message_type' => 'danger',
                'message' => trans('estimate::frontend.estimate_not_found'),
            ]);
    }
}
