<?php

declare(strict_types=1);

namespace Bongo\Estimate\Http\Controllers\Backend;

use Bongo\Estimate\Http\Resources\EstimateResource;
use Bongo\Estimate\Interfaces\StatusInterface;
use Bongo\Estimate\Models\Estimate;
use Bongo\Framework\Http\Controllers\AbstractDatatableController;
use Illuminate\Database\Eloquent\Builder;

class EstimateDatatableController extends AbstractDatatableController
{
    protected Estimate $estimate;

    public function __construct(Estimate $estimate)
    {
        $this->estimate = $estimate;
    }

    protected function getBaseQuery(): Builder
    {
        return $this->estimate->newQuery();
    }

    protected function applyStatusFilter()
    {
        if ($status = $this->request->get('status')) {
            $this->query->where('status', $status);
        } else {
            $this->query->where('status', '!=', StatusInterface::DRAFT);
        }
    }

    protected function applySearchQuery()
    {
        if (isset($this->input['search']) && ! empty($this->input['search'])) {
            $search_query = strtolower(trim($this->input['search']));

            $words = explode(' ', $search_query);
            foreach ($words as $word) {
                if (! empty($word)) {
                    $this->query->where(function ($q) use ($word) {
                        $q->where('number', 'LIKE', "%{$word}%")
                            ->orWhere('first_name', 'LIKE', "%{$word}%")
                            ->orWhere('last_name', 'LIKE', "%{$word}%")
                            ->orWhere('email', 'LIKE', "%{$word}%")
                            ->orWhere('phone', 'LIKE', "%{$word}%")
                            ->orWhere('city', 'LIKE', "%{$word}%")
                            ->orWhere('county', 'LIKE', "%{$word}%")
                            ->orWhere('postcode', 'LIKE', "%{$word}%");
                    });
                }
            }
        }
    }

    protected function setResults()
    {
        $this->results = EstimateResource::collection($this->query->distinct()->get());
    }
}
