<?php

declare(strict_types=1);

namespace Bongo\Estimate\Http\Controllers\Backend;

use Bongo\Estimate\Models\Estimate;
use Bongo\Estimate\Models\EstimateItem;
use Bongo\Framework\Http\Controllers\AbstractController;
use Illuminate\View\View;

class EstimateItemController extends AbstractController
{
    public function index(Estimate $estimate): View
    {
        return view('estimate::backend.items.index', compact('estimate'));
    }

    public function show(Estimate $estimate, EstimateItem $estimateItem): View
    {
        return view('estimate::backend.items.show', compact('estimate', 'estimateItem'));
    }
}
