<?php

declare(strict_types=1);

namespace Bongo\Estimate\Http\Controllers\Backend;

use Bongo\Estimate\Http\Resources\ServiceResource;
use Bongo\Estimate\Models\EstimateService;
use Bongo\Framework\Http\Controllers\AbstractDatatableController;
use Illuminate\Database\Eloquent\Builder;

class ServiceDatatableController extends AbstractDatatableController
{
    protected EstimateService $estimateService;

    public function __construct(EstimateService $estimateService)
    {
        $this->estimateService = $estimateService;
    }

    protected function getBaseQuery(): Builder
    {
        return $this->estimateService->newQuery();
    }

    protected function setResults()
    {
        $this->results = ServiceResource::collection($this->query->distinct()->get());
    }
}
