<?php

declare(strict_types=1);

namespace Bongo\Estimate\Http\Requests\Backend;

use Illuminate\Foundation\Http\FormRequest;

class StoreLocationRequest extends FormRequest
{
    public function rules(): array
    {
        return [
            'name' => 'required|max:75',
            'status' => 'required|in:pending,active,inactive',
            'radius' => 'required|numeric',
            'latitude' => 'required|numeric',
            'longitude' => 'required|numeric',
            'fill' => 'required|max:7',
            'stroke' => 'required|max:7',
            'default' => 'required|boolean',
        ];
    }
}
