<?php

declare(strict_types=1);

namespace Bongo\Estimate\Http\Requests\Frontend;

use Bongo\Captcha\Rules\Captcha;
use Illuminate\Foundation\Http\FormRequest;

class SearchRequest extends FormRequest
{
    public function rules(): array
    {
        $recaptchaEnabled = setting()->reCaptchaEnabled() && config('estimate.recaptcha.enabled');
        $recaptchaMinScore = config('estimate.recaptcha.min_score', 0.5);

        return [
            'line_1' => 'required',
            'postcode' => 'required',

            'captcha-response' => new Captcha(
                action: 'estimate_search',
                minScore: $recaptchaMinScore,
                enabled: $recaptchaEnabled,
            ),
        ];
    }
}
