<?php

declare(strict_types=1);

namespace Bongo\Estimate\Http\Requests\Frontend;

use Bongo\Captcha\Rules\Captcha;
use Illuminate\Foundation\Http\FormRequest;

class StoreStep1Request extends FormRequest
{
    public function rules(): array
    {
        $recaptchaEnabled = setting()->reCaptchaEnabled() && config('estimate.recaptcha.enabled');
        $recaptchaMinScore = config('estimate.recaptcha.min_score', 0.5);

        return [
            'estimate.voucher_code' => 'nullable|string|max:20',

            'estimate.first_name' => 'sometimes|required|string|max:50',
            'estimate.last_name' => 'sometimes|required|string|max:50',
            'estimate.email' => 'sometimes|required|string|email:rfc,dns|max:50',
            'estimate.phone' => 'sometimes|required|string|max:20',

            'estimate.accepted_terms' => 'sometimes|required|numeric',
            'estimate.marketing_emails' => 'sometimes|required|numeric',

            'estimate_item.estimate_service_id' => 'sometimes|required|numeric',

            'captcha-response' => new Captcha(
                action: 'estimate_step_1',
                minScore: $recaptchaMinScore,
                enabled: $recaptchaEnabled,
            ),
        ];
    }
}
