<?php

declare(strict_types=1);

namespace Bongo\Estimate\Http\Requests\Frontend;

use Bongo\Captcha\Rules\Captcha;
use Illuminate\Foundation\Http\FormRequest;

class StoreStep2Request extends FormRequest
{
    public function rules(): array
    {
        $recaptchaEnabled = setting()->reCaptchaEnabled() && config('estimate.recaptcha.enabled');
        $recaptchaMinScore = config('estimate.recaptcha.min_score', 0.5);

        return [
            'latitude' => 'required|numeric',
            'longitude' => 'required|numeric',

            'areas' => 'required|string',
            'marker_moved' => 'required|numeric',
            'total_area_m2' => 'required|numeric',

            'captcha-response' => new Captcha(
                action: 'estimate_step_2',
                minScore: $recaptchaMinScore,
                enabled: $recaptchaEnabled,
            ),
        ];
    }
}
