<?php

declare(strict_types=1);

namespace Bongo\Estimate\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class EstimateResource extends JsonResource
{
    public function toArray($request): array
    {
        return [
            'id' => $this->id,
            'uuid' => $this->uuid,
            'number' => config('estimate.number_prefix').$this->number,

            'date' => ! empty($this->date)
                ? $this->date->format('d/m/Y H:i')
                : null,

            'status' => $this->status,
            'voucher_code' => $this->voucher_code,

            'line_1' => $this->line_1,
            'line_2' => $this->line_2,
            'line_3' => $this->line_3,
            'city' => $this->city,
            'county' => $this->county,
            'postcode' => $this->postcode,
            'latitude' => $this->latitude,
            'longitude' => $this->longitude,

            'first_name' => $this->first_name,
            'last_name' => $this->last_name,
            'email' => $this->email,
            'phone' => $this->phone,
            'accepted_terms' => $this->accepted_terms,
            'marketing_emails' => $this->marketing_emails,

            'created_at' => ! empty($this->created_at)
                ? $this->created_at->format('d/m/Y H:i')
                : null,

            'items_count' => $this->hasItems() ?
                $this->items->count()
                : 0,
        ];
    }
}
