<?php

declare(strict_types=1);

namespace Bongo\Estimate\Maps;

abstract class Map
{
    public const MIN_ZOOM = 1;

    public const MAX_ZOOM = 21;

    public const URL_MAX_LENGTH = 2046;

    public const FORMAT = ['png8', 'png', 'png32', 'jpg', 'gif', 'jpg-baseline'];

    public const MAP_TYPE = ['roadmap', 'satellite', 'hybrid', 'terrain'];

    protected string $key;

    protected int $zoom = 20;

    protected string $size = '750x500';

    protected int $scale = 2;

    protected string $mapType = 'satellite';

    protected array $paths = [];

    protected Point $center;

    public function getKey(): string
    {
        return $this->key;
    }

    public function setKey(string $key): self
    {
        $this->key = $key;

        return $this;
    }

    public function getCenter(): Point
    {
        return $this->center;
    }

    public function setCenter(array $cords): self
    {
        $this->center = new Point($cords);

        return $this;
    }

    public function getZoom(): int
    {
        return $this->zoom;
    }

    public function setZoom(int $zoom): self
    {
        $this->zoom = $zoom;

        return $this;
    }

    public function getSize(): string
    {
        return $this->size;
    }

    public function setSize(string $size): self
    {
        $this->size = $size;

        return $this;
    }

    public function getScale(): int
    {
        return $this->scale;
    }

    public function setScale(int $scale): self
    {
        $this->scale = $scale;

        return $this;
    }

    public function getMapType(): string
    {
        return $this->mapType;
    }

    public function setMapType(string $mapType): self
    {
        $this->mapType = $mapType;

        return $this;
    }

    public function getPaths(): array
    {
        return $this->paths;
    }

    public function setPaths(array $paths): self
    {
        $this->paths = $paths;

        return $this;
    }

    public function addPath(Path $path): self
    {
        $this->paths[] = $path;

        return $this;
    }

    abstract public function generateUrl(): string;

    public function generateImage(string $name, string $path): string
    {
        return (new ImageGenerator($this->generateUrl(), $name, $path))->generate();
    }
}
