<?php

declare(strict_types=1);

namespace Bongo\Estimate\Maps;

abstract class URLGenerator
{
    public const BASE_URL = 'https://maps.googleapis.com/maps/api/staticmap?';

    protected Map $map;

    protected array $params = [];

    public function __construct(Map $map)
    {
        $this->map = $map;
    }

    abstract public function generate(): string;

    abstract public function encodeCoordinates(array $coordinates): string;

    protected function getMapParams(): string
    {
        $this->params['key'] = $this->map->getKey();
        $this->params['maptype'] = $this->map->getMaptype();
        $this->params['zoom'] = $this->map->getZoom();
        $this->params['size'] = $this->map->getSize();
        $this->params['scale'] = $this->map->getScale();

        $center = $this->map->getCenter();
        $this->params['center'] = $center->getLat().','.$center->getLng();

        return http_build_query($this->params, '', '&');
    }

    protected function getPathParams(): string
    {
        $paths = $this->map->getPaths();
        if (empty($paths)) {
            return '';
        }

        $pathParams = '';
        foreach ($paths as $path) {
            $pathParams .= '&'.$this->buildPathParam($path);
        }

        return $pathParams;
    }

    public function buildPathParam(Path $path): string
    {
        $coordinates = $path->getCoordinates();
        if (empty($coordinates)) {
            return '';
        }

        $fillColor = $path->getFillColor();
        $strokeColor = $path->getStrokeColor();
        $strokeWeight = $path->getStrokeWeight();
        $encodedCoordinates = $this->encodeCoordinates($coordinates);

        return "path=fillcolor:{$fillColor}|color:{$strokeColor}|weight:{$strokeWeight}|enc:{$encodedCoordinates}";
    }
}
