<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class() extends Migration
{
    public function up(): void
    {
        if (! Schema::hasColumn('estimates', 'voucher_code')) {
            Schema::table('estimates', function (Blueprint $table) {
                $table->string('voucher_code')
                    ->nullable()
                    ->after('status');
            });
        }
    }

    public function down(): void
    {
        Schema::table('estimates', function (Blueprint $table) {
            $table->dropColumn('voucher_code');
        });
    }
};
