<?php

declare(strict_types=1);

use Bongo\Estimate\Interfaces\StatusInterface;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class() extends Migration
{
    public function up(): void
    {
        Schema::create('estimate_items', function (Blueprint $table) {

            $table->increments('id');

            $table->uuid('uuid')
                ->index();

            $table->unsignedInteger('estimate_id')
                ->index();

            $table->foreign('estimate_id')
                ->references('id')
                ->on('estimates')
                ->onUpdate('cascade')
                ->onDelete('cascade');

            $table->unsignedInteger('estimate_service_id')
                ->nullable()
                ->index();

            $table->foreign('estimate_service_id')
                ->references('id')
                ->on('estimate_services')
                ->onUpdate('cascade')
                ->onDelete('cascade');

            $table->unsignedInteger('estimate_plan_id')
                ->nullable()
                ->index();

            $table->string('number')
                ->nullable()
                ->index();

            $table->unsignedTinyInteger('step')
                ->default(1);

            $table
                ->enum('status', [
                    StatusInterface::DRAFT,
                    StatusInterface::PENDING,
                    StatusInterface::ACCEPTED,
                    StatusInterface::REJECTED,
                ])
                ->default(StatusInterface::DRAFT);

            // Measurement data
            $table->longText('areas')
                ->nullable();

            $table->tinyInteger('marker_moved')
                ->default(0);

            $table->string('total_area_m2')
                ->nullable();

            $table->timestamp('sent_at')
                ->nullable()
                ->index();

            $table->timestamp('exported_at')
                ->nullable()
                ->index();

            $table->text('export_error')
                ->nullable();

            $table->unsignedInteger('created_by')
                ->nullable()
                ->index();

            $table->unsignedInteger('updated_by')
                ->nullable()
                ->index();

            $table->unsignedInteger('deleted_by')
                ->nullable()
                ->index();

            // Timestamps
            $table->timestamps();
            $table->softDeletes();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('estimate_items');
    }
};
