<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class() extends Migration
{
    public function up(): void
    {
        // Create the estimate_item_prices table
        Schema::create('estimate_item_prices', function (Blueprint $table) {

            $table->increments('id');

            $table->uuid('uuid')
                ->index();

            $table->unsignedInteger('estimate_item_id')
                ->index();

            $table->foreign('estimate_item_id')
                ->references('id')
                ->on('estimate_items')
                ->onUpdate('cascade')
                ->onDelete('cascade');

            $table->unsignedInteger('estimate_plan_id')
                ->index();

            $table->foreign('estimate_plan_id')
                ->references('id')
                ->on('estimate_plans')
                ->onUpdate('cascade')
                ->onDelete('cascade');

            $table->unsignedInteger('estimate_plan_item_id')
                ->index();

            $table->foreign('estimate_plan_item_id')
                ->references('id')
                ->on('estimate_plan_items')
                ->onUpdate('cascade')
                ->onDelete('cascade');

            $table->unsignedInteger('cost_per_m2')
                ->nullable();

            // Price / totals
            $table->unsignedInteger('subtotal')
                ->nullable();

            $table->unsignedInteger('tax_rate')
                ->nullable();

            $table->unsignedInteger('tax')
                ->nullable();

            $table->unsignedInteger('total')
                ->nullable();

            $table->unsignedInteger('price_per_month')
                ->nullable();

            $table->unsignedInteger('created_by')
                ->nullable()
                ->index();

            $table->unsignedInteger('updated_by')
                ->nullable()
                ->index();

            $table->unsignedInteger('deleted_by')
                ->nullable()
                ->index();

            // Timestamps
            $table->timestamps();
            $table->softDeletes();
        });

        // Run the command to migrate the existing data
        if (config('estimate.auto_upgrade_to_v4')) {
            Artisan::call('estimate:upgrade_to_v4');
        }
    }

    public function down(): void
    {
        Schema::dropIfExists('estimate_item_prices');
    }
};
