<?php

declare(strict_types=1);

namespace Bongo\Estimate\Models;

use Bongo\Estimate\Concerns\CanBeExported;
use Bongo\Estimate\Database\Factories\EstimateFactory;
use Bongo\Estimate\Interfaces\StatusInterface;
use Bongo\Estimate\Traits\HasAddress;
use Bongo\Estimate\Traits\HasContact;
use Bongo\Estimate\Traits\HasDate;
use Bongo\Estimate\Traits\HasNumber;
use Bongo\Estimate\Traits\HasStatus;
use Bongo\Estimate\Traits\HasVoucherCode;
use Bongo\Framework\Models\AbstractModel;
use Bongo\Framework\Traits\HasUUID;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\SoftDeletes;

class Estimate extends AbstractModel implements StatusInterface
{
    use CanBeExported;
    use HasAddress;
    use HasContact;
    use HasDate;
    use HasFactory;
    use HasNumber;
    use HasStatus;
    use HasUUID;
    use HasVoucherCode;
    use SoftDeletes;

    /** @var array */
    protected $fillable = [];

    /** @var array */
    protected $casts = [];

    public function items(): HasMany
    {
        return $this->hasMany(EstimateItem::class, 'estimate_id');
    }

    public function hasItems(): bool
    {
        $this->loadMissing('items');

        return ! is_null($this->items) && count($this->items);
    }

    protected static function newFactory(): EstimateFactory
    {
        return EstimateFactory::new();
    }
}
