<?php

declare(strict_types=1);

namespace Bongo\Estimate\Models;

use Bongo\Estimate\Database\Factories\EstimateLocationFactory;
use Bongo\Estimate\Traits\HasDefault;
use Bongo\Framework\Interfaces\StatusInterface;
use Bongo\Framework\Models\AbstractModel;
use Bongo\Framework\Traits\HasKey;
use Bongo\Framework\Traits\HasStatus;
use Bongo\Framework\Traits\HasUUID;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;

class EstimateLocation extends AbstractModel implements StatusInterface
{
    use HasDefault;
    use HasFactory;
    use HasKey;
    use HasStatus;
    use HasUUID;
    use SoftDeletes;

    /** @var array */
    protected $fillable = [
        'name',
        'radius',
        'latitude',
        'longitude',
        'fill',
        'stroke',
    ];

    protected static function newFactory(): EstimateLocationFactory
    {
        return EstimateLocationFactory::new();
    }
}
