<?php

declare(strict_types=1);

namespace Bongo\Estimate\Models;

use Bongo\Estimate\Database\Factories\EstimatePlanItemFactory;
use Bongo\Framework\Casts\Pence;
use Bongo\Framework\Models\AbstractModel;
use Bongo\Framework\Traits\HasUUID;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\SoftDeletes;

class EstimatePlanItem extends AbstractModel
{
    use HasFactory;
    use HasUUID;
    use SoftDeletes;

    /** @var array */
    protected $fillable = [
        'estimate_plan_id',
        'area_m2',
        'cost_per_m2',
        'sort_order',
    ];

    /** @var array */
    protected $casts = [
        'area_m2' => 'decimal:2',
        'cost_per_m2' => Pence::class,
    ];

    public function plan(): BelongsTo
    {
        return $this->belongsTo(EstimatePlan::class, 'estimate_plan_id');
    }

    protected static function newFactory(): EstimatePlanItemFactory
    {
        return EstimatePlanItemFactory::new();
    }
}
