@extends('framework::backend.layouts.app')

@section('content')
    @component('blade::content_header')
        {{ config('estimate.number_prefix').$estimate->number }} - {{ $estimate->name }}
        @slot('actions')
            @backButton(['name' => trans('estimate::backend.index'), 'url' => route('backend.estimate.index')])
        @endslot
    @endcomponent

    @component('blade::content_body')
        @include('estimate::backend.details.partials.navigation')
        <section class="mt-4">
            @if ($estimate->hasItems())
                <div class="grid md:grid-cols-2 gap-3">
                    @foreach($estimate->items as $key => $estimateItem)
                        @include('estimate::backend.items.partials.item', [
                            'key' => $key,
                            'estimate' => $estimate,
                            'estimateItem' => $estimateItem,
                        ])
                    @endforeach
                </div>
            @else
                @component('blade::card')
                    <div class="message text-center">
                        <div class="message-text font-semibold">
                            No Estimate Items Found
                        </div>
                    </div>
                @endcomponent
            @endif
        </section>
    @endcomponent
@stop
