<section class="md:grid md:grid-cols-2 md:gap-6">

    <div class="md:col-span-1">
        @component('blade::card', ['cardClass' => 'mb-4 md:mb-0'])
            <div class="grid grid-cols-1 col-gap-4 row-gap-4 sm:grid-cols-2">
                <div class="sm:col-span-1">
                    @input([
                        'name' => 'name',
                        'value' => $estimateLocation->name,
                        'placeholder' => 'Norwich',
                        'required' => 'true'
                    ])
                </div>
                <div class="sm:col-span-1">
                    @select([
                        'name' => 'status',
                        'value' => $estimateLocation->status,
                        'options' => get_enum_values('estimate_locations', 'status')
                    ])
                </div>
                <div class="sm:col-span-1">
                    <div class="form-group">
                        <span class="text-sm leading-5 font-medium text-gray-500">
                            Fill Colour
                        </span>
                        <v-colorpicker
                            name="fill"
                            value="{{ $estimateLocation->fill }}"
                        ></v-colorpicker>
                    </div>
                </div>
                <div class="sm:col-span-1">
                    <div class="form-group">
                        <span class="text-sm leading-5 font-medium text-gray-500">
                            Stroke Colour
                        </span>
                        <v-colorpicker
                            name="stroke"
                            value="{{ $estimateLocation->stroke }}"
                        ></v-colorpicker>
                    </div>
                </div>
            </div>
        @endcomponent
    </div>

    <div class="md:col-span-1">
        @component('blade::card', ['cardClass' => 'mb-4 md:mb-0'])
            <div class="grid grid-cols-1 col-gap-4 row-gap-4 sm:grid-cols-2">
                <div class="sm:col-span-1">
                    @input([
                        'name' => 'latitude',
                        'value' => $estimateLocation->latitude,
                        'placeholder' => '52.563742665132075',
                        'required' => 'true'
                    ])
                </div>
                <div class="sm:col-span-1">
                    @input([
                        'name' => 'longitude',
                        'value' => $estimateLocation->longitude,
                        'placeholder' => '1.3434560974272856',
                        'required' => 'true'
                    ])
                </div>
                <div class="sm:col-span-1">
                    @input([
                        'name' => 'radius',
                        'value' => $estimateLocation->radius,
                        'placeholder' => '20',
                        'required' => 'true'
                    ])
                </div>
                <div class="sm:col-span-1">
                    @select([
                        'name' => 'default',
                        'value' => $estimateLocation->default,
                        'options' => [
                            '0' => 'No',
                            '1' => 'Yes'
                        ]
                    ])
                </div>
            </div>
        @endcomponent
    </div>

</section>
