<form
    id="estimate-contact-form"
    class="has-captcha"
    action="{{ route('frontend.estimate.step_1.store') }}"
    method="POST"
>
    <div class="validation {{ uniqid('v-') }}">
        {{ csrf_field() }}
        @honeypot
        @if(setting()->reCaptchaEnabled())
            {!! captcha()->field('estimate_step_1') !!}
        @endif
    </div>

    <div class="wizard-content">
        <section class="address-details">
            <h2>Address Details</h2>
            <p>
                We found the following location for your postcode, is this correct?
                <a href="{{ route('frontend.estimate.reset_address') }}">Reset Address</a>
            </p>
            <div class="address-result">
                {{ $estimate->address }}
            </div>
        </section>
        <section class="contact-details">
            <h2>Contact Details</h2>
            <p>In order to send your quote, please enter your contact details below.</p>
            <div class="row">
                <div class="col-md-6">
                    <div class="form-group">
                        <input
                            class="form-control"
                            name="estimate[first_name]"
                            type="text"
                            maxlength="50"
                            value="{{ old('estimate.first_name', $estimate->first_name) }}"
                            placeholder="Your First Name..."
                            autocomplete="given-name"
                            required
                        >
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-group">
                        <input
                            class="form-control"
                            name="estimate[last_name]"
                            type="text"
                            maxlength="50"
                            value="{{ old('estimate.last_name', $estimate->last_name) }}"
                            placeholder="Your Last Name..."
                            autocomplete="family-name"
                            required
                        >
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-group">
                        <input
                            class="form-control"
                            name="estimate[email]"
                            type="email"
                            maxlength="100"
                            value="{{ old('estimate.email', $estimate->email) }}"
                            placeholder="Your Email Address..."
                            autocomplete="email"
                            required
                        >
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-group">
                        <input
                            class="form-control"
                            name="estimate[phone]"
                            type="text"
                            maxlength="20"
                            value="{{ old('estimate.phone', $estimate->phone) }}"
                            placeholder="Your Mobile Number Including Area Code..."
                            autocomplete="tel"
                            required
                        >
                    </div>
                </div>
                @if(config('estimate.voucher_code_enabled'))
                    <div class="col-md-6">
                        <div class="form-group">
                            <input
                                class="form-control"
                                name="estimate[voucher_code]"
                                type="text"
                                maxlength="20"
                                value="{{ old('estimate.voucher_code', $estimate->voucher_code) }}"
                                placeholder="Voucher Code..."
                            >
                        </div>
                    </div>
                    <div class="col-md-6 d-none d-md-block">&nbsp;</div>
                @endif
                <div class="col-md-6">
                    <div class="form-group">
                        <div class="form-check">
                            <input type="hidden" name="estimate[accepted_terms]" value="0">
                            <input
                                id="accepted-terms"
                                class="form-check-input"
                                type="checkbox"
                                name="estimate[accepted_terms]"
                                value="1"
                                {{ old('estimate.accepted_terms', $estimate->accepted_terms == 1) ? 'checked' : '' }}
                                required
                            />
                            <label id="accepted-terms-label" class="form-check-label" for="accepted-terms">
                                I confirm that I have read and agree to the
                                <a href="{{ url(setting('package::estimate.terms_url', '/')) }}"
                                   target="_blank"
                                >terms and conditions
                                </a>
                                .
                            </label>
                        </div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-group">
                        <div class="form-check">
                            <input type="hidden" name="estimate[marketing_emails]" value="0">
                            <input
                                id="marketing-emails"
                                class="form-check-input"
                                type="checkbox"
                                name="estimate[marketing_emails]"
                                {{ old('estimate.marketing_emails', $estimate->marketing_emails == 1) ? 'checked' : '' }}
                                value="1"
                            />
                            <label id="marketing-emails-label" class="form-check-label" for="marketing-emails">
                                I would like to receive tips, advice and news
                                from {{ setting("client::company.name") }}.
                                I understand I can unsubscribe at any time. We’ll always keep your information
                                safe and won’t share it with other companies for their marketing purposes.
                            </label>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        @if(count($estimateServices) > 1)
            <section class="service-details">
                <h2>Service Required</h2>
                <p>Please select a service below.</p>
                <div class="services">
                    @foreach($estimateServices as $estimateService)
                        @include('estimate::frontend.step_1.partials.service', [
                            'estimateItem' => $estimateItem,
                            'estimateService' => $estimateService,
                            'checked' => ! empty($estimateItem->estimate_service_id)
                                ? $estimateItem->estimate_service_id === $estimateService->id
                                : $estimateService->default,
                        ])
                    @endforeach
                    @error('estimate_item.estimate_service_id')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
            </section>
        @endif
    </div>

    <div class="wizard-actions">
        <div class="wizard-next">
            @include('estimate::frontend.step_1.partials.next_step_button')
        </div>
        <div class="wizard-previous">
            @include('estimate::frontend.step_1.partials.back_to_home_button')
        </div>
    </div>
</form>

@section('footer_javascript')
    @parent
    @if(setting()->reCaptchaEnabled())
        {!! captcha()->script('estimate_step_1') !!}
    @endif
@endsection
