<form
    id="estimate-search-form"
    class="has-captcha"
    action="{{ route('frontend.estimate.search') }}"
    method="POST"
>
    <div class="validation {{ uniqid('v-') }}">
        {{ csrf_field() }}
        @honeypot
        @if(setting()->reCaptchaEnabled())
            {!! captcha()->field('estimate_search') !!}
        @endif
    </div>
    <div class="wizard-content">
        <section class="address-details">
            <h2>Address Details</h2>
            <p>Please enter the first line and postcode of your address, to measure your lawn</p>
            <div class="row">
                <div class="col-md-8">

                    <div class="input-group">
                        <input
                            class="form-control w-md-40"
                            name="line_1"
                            type="text"
                            maxlength="50"
                            value="{{ old('line_1', $estimate->line_1) }}"
                            placeholder="e.g. 48, common rd"
                            autocomplete="line-1"
                            required
                        >
                        <input
                            class="form-control w-md-30"
                            name="postcode"
                            type="text"
                            maxlength="10"
                            value="{{ old('postcode', $estimate->postcode) }}"
                            placeholder="{{ setting('package::estimate.postcode_placeholder') }}"
                            autocomplete="postal-code"
                            required
                        >
                        <div class="input-group-append">
                            @include('estimate::frontend.step_1.partials.search_button')
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
</form>

@section('footer_javascript')
    @parent
    @if(setting()->reCaptchaEnabled())
        {!! captcha()->script('estimate_search') !!}
    @endif
@endsection
