<form
    id="estimate-services-form"
    class="has-captcha"
    action="{{ route('frontend.estimate.step_1.store') }}"
    method="POST"
>
    <div class="validation {{ uniqid('v-') }}">
        {{ csrf_field() }}
        @honeypot
        @if(setting()->reCaptchaEnabled())
            {!! captcha()->field('estimate_step_1') !!}
        @endif
    </div>

    <div class="wizard-content">
        <section class="address-details">
            <h2>Address Details</h2>
            <p>
                We found the following address details, are they correct?
                <a href="{{ route('frontend.estimate.reset_address') }}">Reset Address</a>
            </p>
            <div class="address-result">
                {{ $estimate->address }}
            </div>
        </section>
        <section class="contact-details">
            <h2>Contact Details</h2>
            <p>
                We found the following contact details, are they correct?
                <a href="{{ route('frontend.estimate.reset_contact') }}">Reset Contact</a>
            </p>
            <div class="contact-result">
                @if(! empty($estimate->first_name))
                    {{ $estimate->first_name }}
                @endif
                @if(! empty($estimate->last_name))
                    {{ $estimate->last_name }},&nbsp;
                @endif
                @if(! empty($estimate->email))
                    {{ $estimate->email }},&nbsp;
                @endif
                @if(! empty($estimate->phone))
                    {{ $estimate->phone }}
                @endif
            </div>
        </section>
        @if(count($estimateServices) > 1)
            <section class="service-details">
                <h2>Service Required</h2>
                <p>Please select a service below.</p>
                <div class="services">
                    @foreach($estimateServices as $estimateService)
                        @include('estimate::frontend.step_1.partials.service', [
                            'estimateItem' => $estimateItem,
                            'estimateService' => $estimateService,
                            'checked' => ! empty($estimateItem->estimate_service_id)
                                ? $estimateItem->estimate_service_id === $estimateService->id
                                : $estimateService->default,
                        ])
                    @endforeach
                    @error('estimate_item.estimate_service_id')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
            </section>
        @endif
    </div>

    <div class="wizard-actions">
        <div class="wizard-next">
            @include('estimate::frontend.step_1.partials.next_step_button')
        </div>
        <div class="wizard-previous">
            @include('estimate::frontend.step_1.partials.back_to_home_button')
        </div>
    </div>
</form>

@section('footer_javascript')
    @parent
    @if(setting()->reCaptchaEnabled())
        {!! captcha()->script('estimate_step_1') !!}
    @endif
@endsection
