@extends('estimate::frontend.layout')

@section('body_class', 'estimate-page')
@section('page_title', 'Step 2 > '.setting('package::estimate.step_2'))
@section('meta_title', 'Step 2 > '.setting('package::estimate.step_2'))
@section('meta_description', 'Step 2 > '.setting('package::estimate.step_2'))

@section('wizard_content')
    <form
        id="step-2-form"
        class="has-captcha"
        action="{{ route('frontend.estimate.step_2.store') }}"
        method="POST"
    >
        <div class="validation {{ uniqid('v-') }}">
            {{ csrf_field() }}
            @honeypot
            @if(setting()->reCaptchaEnabled())
                {!! captcha()->field('estimate_step_2') !!}
            @endif
        </div>

        <input id="latitude-input" type="hidden" name="latitude" value="{{ $estimate->latitude }}">
        <input id="longitude-input" type="hidden" name="longitude" value="{{ $estimate->longitude }}">
        <input id="areas-input" type="hidden" name="areas" value="{{ $estimateItem->areas }}">
        <input id="marker-moved-input" type="hidden" name="marker_moved" value="{{ $estimate->marker_moved ?? 0 }}">
        <input id="total-area-input" type="hidden" name="total_area_m2" value="{{ $estimateItem->total_area_m2 ?? 0 }}">

        <div class="wizard-content">
            @include('estimate::frontend.step_2.partials.instructions')
            @include('estimate::frontend.step_2.partials.map')
        </div>

        <div class="wizard-actions">
            <div class="wizard-next">
                @include('estimate::frontend.step_2.partials.get_my_quote_button')
            </div>
            <div class="wizard-previous">
                @include('estimate::frontend.step_2.partials.previous_step_button')
            </div>
        </div>
    </form>
@stop

@section('footer_javascript')
    @parent
    @if(setting()->reCaptchaEnabled())
        {!! captcha()->script('estimate_step_2') !!}
    @endif
    <script src="{{ asset('/js/estimate.js') }}"></script>
    <script src="https://maps.googleapis.com/maps/api/js?key={{ setting('system::credentials.google_maps_api_key') }}&callback=initMap&libraries=geometry,drawing&v=weekly"></script>
@endsection
