<section class="pricing-table">
    <table class="table table-bordered table-striped">
        <thead>
            <tr>
                <th class="plan">Plan</th>
                <th class="total">Per Treatment</th>
                <th class="per-month">Per Month</th>
            </tr>
        </thead>
        <tbody>
            @foreach($estimateItem->prices as $price)
                <tr class="{{ $price->plan->key ?? '' }}">
                    <td class="plan">
                        <div>{{ $price->plan->name ?? '-- --' }}</div>
                        @if($price->plan->isPerTreatmentAndPerMonth())
                            <div class="installments">
                                {{ $price->plan?->treatments ?? '-- --' }} Treatments
                                Across {{ $price->plan?->visits ?? '-- --' }} Visits
                            </div>
                        @endif
                    </td>
                    <td class="price total">
                        @if($price->plan->isPerTreatment() || $price->plan->isPerTreatmentAndPerMonth())
                            £{{ ! empty($price->total) ? number_format($price->total, 2) : '0.00' }}
                        @else
                            <span class="not-applicable">N/A</span>
                        @endif
                    </td>
                    <td class="price per-month">
                        @if($price->plan->isPerTreatmentAndPerMonth())
                            £{{ ! empty($price->price_per_month) ? number_format($price->price_per_month, 2) : '0.00' }}
                        @elseif($price->plan->isPerMonth())
                            £{{ ! empty($price->total) ? number_format($price->total, 2) : '0.00' }}
                        @else
                            <span class="not-applicable">N/A</span>
                        @endif
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>
</section>
