<section class="pricing-table">
    <table class="table table-bordered table-striped">
        <thead>
            <tr>
                <th class="plan">Plan</th>
                <th class="subtotal">Subtotal</th>
                <th class="vat">VAT</th>
                <th class="total">Total</th>
            </tr>
        </thead>
        <tbody>
            @foreach($estimateItem->prices as $price)
                <tr class="{{ $price->plan->key ?? '' }}">
                    <td class="plan">
                        <div>{{ $price->plan->name ?? '-- --' }}</div>
                        @if($price->plan->isPerTreatmentAndPerMonth())
                            <div class="installments">
                                {{ $price->plan?->treatments ?? '-- --' }} Treatments
                                Across {{ $price->plan?->visits ?? '-- --' }} Visits
                            </div>
                        @elseif($price->plan->isPerTreatment())
                            <div class="installments">
                                Per Treatment
                            </div>
                        @elseif($price->plan->isPerMonth())
                            <div class="installments">
                                Per Month
                            </div>
                        @endif
                    </td>
                    <td class="price subtotal">
                        £{{ ! empty($price->subtotal) ? number_format($price->subtotal, 2) : '0.00' }}
                    </td>
                    <td class="price vat">
                        £{{ ! empty($price->tax) ? number_format($price->tax, 2) : '0.00' }}
                    </td>
                    <td class="price total">
                        £{{ ! empty($price->total) ? number_format($price->total, 2) : '0.00' }}

                        @if($price->plan->isPerTreatmentAndPerMonth())
                            <div class="installments fw-bold">
                                or £{{ ! empty($price->price_per_month) ? number_format($price->price_per_month, 2) : '0.00' }} per month
                            </div>
                        @endif
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>
</section>
