<div class="totals mt-2">
    <div>
        <strong>Subtotal:</strong>
        £{{ ! empty($singlePrice->subtotal) ? number_format($singlePrice->subtotal, 2) : '0.00' }}
    </div>
    <div>
        <strong>VAT:</strong>
        £{{ ! empty($singlePrice->tax) ? number_format($singlePrice->tax, 2) : '0.00' }}
    </div>
    <div>
        <strong>Total:</strong>
        £{{ ! empty($singlePrice->total) ? number_format($singlePrice->total, 2) : '0.00' }}
    </div>
</div>

@if($singlePrice->hasPlan())
    @if($singlePrice->plan->isPerTreatmentAndPerMonth())
        <div class="disclaimer mt-2">
            Price per treatment, of which there are {{ $singlePrice->plan->chargeable_treatments }}
            chargeable treatments per year.
        </div>
        <div class="mt-4">
            <strong>Via monthly installments</strong> =
            £{{ ! empty($singlePrice->price_per_month) ? number_format($singlePrice->price_per_month, 2) : '0.00' }} per
            month
        </div>

    @elseif($singlePrice->plan->isPerTreatment())
        <div class="disclaimer mt-2">
            Price per treatment.
        </div>

    @elseif($singlePrice->plan->isPerMonth())
        <div class="disclaimer mt-2">
            Price per month.
        </div>
    @endif
@endif
