// Workaround for polygon labels
function LabelOverlay(e) {
    this._args = e;
    this._div = null;
    this.onRemove();
    if (e.minBoxH && e.minBoxW && !e.minBox) {
        e.minBox = this._buildBox(e.ll, e.minBoxW, e.minBoxH)
    }
    if (e.maxBoxH && e.maxBoxW && !e.maxBox) {
        e.maxBox = this._buildBox(e.ll, e.maxBoxW, e.maxBoxH)
    }
    this.setMap(e.map)
}
LabelOverlay.prototype = new google.maps.OverlayView;
LabelOverlay.prototype._buildBox = function (e, a, t) {
    var r = new gMaps.LatLng(e.lat() - t / 2, e.lng() - a / 2);
    var i = new gMaps.LatLng(e.lat() + t / 2, e.lng() + a / 2);
    return new gMaps.LatLngBounds(r, i)
};
LabelOverlay.prototype.onAdd = function () {
    var e = document.getElementById(this._args.overlayID);
    if (e) e.parentNode.removeChild(e);
    var a = "gmaps-label";
    if (this._args.className) a += " " + this._args.className;
    var t = document.createElement("div");
    t.setAttribute("id", this._args.overlayID);
    t.className = a;
    if (this._args.labelElement) {
        t.appendChild(this._args.labelElement)
    } else {
        t.innerHTML = this._args.label
    }
    this._div = t;
    var r = this.getPanes();
    r.overlayImage.appendChild(t)
};
LabelOverlay.prototype.draw = function () {
    var e = this.getProjection();
    var a = this._args.map.getZoom();
    var t = e.fromLatLngToDivPixel(this._args.ll);
    var r = this._div;
    var i = 1;
    var o = 1;
    var n = true;
    if (this._args.maxZoom && a > this._args.maxZoom) n = false;
    if (this._args.minZoom && a < this._args.minZoom) n = false;
    if (this._args.minBox) {
        var l = e.fromLatLngToDivPixel(this._args.minBox.getNorthEast());
        var m = e.fromLatLngToDivPixel(this._args.minBox.getSouthWest());
        var _ = Math.abs(t.x - l.x);
        var s = Math.abs(t.x - m.x);
        var v = Math.abs(t.y - l.y);
        var u = Math.abs(t.y - m.y);
        if (_ < i / 2) n = false;
        if (s < i / 2) n = false;
        if (v < o / 2) n = false;
        if (u < o / 2) n = false
    }
    if (this._args.maxBox) {
        var l = e.fromLatLngToDivPixel(this._args.maxBox.getNorthEast());
        var m = e.fromLatLngToDivPixel(this._args.maxBox.getSouthWest());
        var _ = Math.abs(t.x - l.x);
        var s = Math.abs(t.x - m.x);
        var v = Math.abs(t.y - l.y);
        var u = Math.abs(t.y - m.y);
        if (_ > i / 2) n = false;
        if (s > i / 2) n = false;
        if (v > o / 2) n = false;
        if (u > o / 2) n = false
    }
    if (this._args.debugVisibility) {
        r.style.visibility = "visible";
        r.style.color = n ? "white" : "red"
    } else {
        r.style.visibility = n ? "visible" : "hidden";
        if (!n) return
    }
    r.style.left = t.x - i / 2 + "px";
    r.style.top = t.y - o / 2 + "px"
};
LabelOverlay.prototype.onRemove = function () {
    if (this._div) {
        this._div.parentNode.removeChild(this._div);
        this._div = null;
        if (this._minBox) {

        }
        if (this._maxBox) {

        }
    }
};
