<?php

namespace Bongo\Estimate\Actions;

class CalculateDistance
{
    /**
     * @return float|int
     */
    public static function inMiles(
        float $fromLatitude,
        float $fromLongitude,
        float $toLatitude,
        float $toLongitude
    ) {
        $milesMultiplier = 3959;

        $distance = acos(
            sin(deg2rad($fromLatitude)) * sin(deg2rad($toLatitude)) + cos(deg2rad($fromLatitude))
            * cos(deg2rad($toLatitude)) * cos(deg2rad($fromLongitude) - deg2rad($toLongitude))
        );

        return $distance * $milesMultiplier;
    }

    /**
     * @return float|int
     */
    public static function inKilometers(
        float $fromLatitude,
        float $fromLongitude,
        float $toLatitude,
        float $toLongitude
    ) {
        $kilometersMultiplier = 6380;

        $distance = acos(
            sin(deg2rad($fromLatitude)) * sin(deg2rad($toLatitude)) + cos(deg2rad($fromLatitude))
            * cos(deg2rad($toLatitude)) * cos(deg2rad($fromLongitude) - deg2rad($toLongitude))
        );

        return $distance * $kilometersMultiplier;
    }
}
