<?php

namespace Bongo\Estimate\Actions;

use Bongo\Estimate\Models\Estimate;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;

class FindEstimate
{
    /**
     * @param  string|null  $uuid
     * @return Builder|Model|object|null
     */
    public static function byUuid(?string $uuid)
    {
        return Estimate::query()
            ->where('uuid', $uuid)
            ->whereIn('status', [Estimate::DRAFT, Estimate::PENDING])
            ->first();
    }
}
