<?php

namespace Bongo\Estimate\Actions;

use Bongo\Estimate\Models\Estimate;

class GenerateNumber
{
    public static function forEstimate(): int
    {
        $latestEstimate = Estimate::query()
            ->orderBy('created_at', 'DESC')
            ->orderBy('number', 'DESC')
            ->withTrashed()
            ->first();

        if ($latestEstimate) {
            return $latestEstimate->number + 1;
        }

        // Create the number based on the sum count
        return Estimate::query()->count() + 1;
    }
}
