<?php

namespace Bongo\Estimate\Http\Controllers\Frontend;

use Bongo\Estimate\Actions\FindEstimate;
use Bongo\Estimate\Events\EstimateUpdated;
use Bongo\Estimate\Http\Requests\StoreStep1Request;
use Bongo\Estimate\Models\Estimate;
use Bongo\Framework\Http\Controllers\AbstractController;
use Illuminate\Http\RedirectResponse;

class Step1Controller extends AbstractController
{
    public function index(): RedirectResponse
    {
        return redirect()->route('frontend.estimate.step_1.show');
    }

    public function show()
    {
        // Find or create the estimate
        if (! $estimate = FindEstimate::byUuid(session('estimate_id'))) {
            $estimate = Estimate::create();
            session(['estimate_id' => $estimate->uuid]);
        }
        $estimate->setStepAs(1);

        return view('estimate::frontend.step_1', [
            'estimate' => $estimate,
        ]);
    }

    public function store(StoreStep1Request $request): RedirectResponse
    {
        // Find the estimate or fail
        if (! $estimate = FindEstimate::byUuid(session('estimate_id'))) {
            session()->forget('estimate_id');

            return redirect()->route('frontend.estimate.step_1.show');
        }

        // Validate the input
        $validated = $request->validated();

        // Store the details and continue
        $estimate->fill($validated);
        $estimate->step = 2;
        $estimate->status = Estimate::PENDING;
        $estimate->save();

        // Fire the event for anyone who is listening
        event(new EstimateUpdated($estimate));

        return redirect()->route('frontend.estimate.step_2.show');
    }
}
