<?php

namespace Bongo\Estimate\Http\Controllers\Frontend;

use Bongo\Estimate\Actions\FindEstimate;
use Bongo\Estimate\Events\EstimateUpdated;
use Bongo\Estimate\Http\Requests\StoreStep2Request;
use Bongo\Framework\Http\Controllers\AbstractController;
use Illuminate\Http\RedirectResponse;

class Step2Controller extends AbstractController
{
    public function show()
    {
        // Find the estimate or fail
        $estimate = FindEstimate::byUuid(session('estimate_id'));
        if (! $estimate || intval($estimate->step) < 2) {
            return redirect()->route('frontend.estimate.step_1.show');
        }
        $estimate->setStepAs(2);

        return view('estimate::frontend.step_2', [
            'estimate' => $estimate,
        ]);
    }

    public function store(StoreStep2Request $request): RedirectResponse
    {
        // Find the estimate or fail
        $estimate = FindEstimate::byUuid(session('estimate_id'));
        if (! $estimate || intval($estimate->step) < 2) {
            return redirect()->route('frontend.estimate.step_1.show');
        }

        // Validate the input
        $validated = $request->validated();

        // Store the details and continue
        $estimate->fill($validated);
        $estimate->step = 3;
        $estimate->save();

        // Fire the event for anyone who is listening
        event(new EstimateUpdated($estimate));

        return redirect()->route('frontend.estimate.step_3.show');
    }
}
